﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

public class TimerIntervalRange : TimerInterval, ICloneable<TimerInterval>
{
    public int LowRangeValue { get; private set; }  //The lower range

    public int HighRangeValue { get; private set; } //The upper range

    public int RemainingValues { get; private set; }    //The amount of values in the range remaining

    private bool _LowRangeInclusive;

    public TimerIntervalRange(int lowRange, int highRange, bool lowRangeInclusive = false) : base(highRange)
    {
        LowRangeValue = lowRange;
        HighRangeValue = highRange;
        _LowRangeInclusive = lowRangeInclusive;
        RemainingValues = (HighRangeValue - LowRangeValue) / 1000;  //Convert to milliseconds

        if(_LowRangeInclusive)  //We want to tick on the last value of the range, so increment
        {
            RemainingValues++;
        }
    }

    public override void PlayTick()
    {
        //Decrement the values, set the next millisecond interval and play the audio
        RemainingValues--;
        IntervalValue = RemainingValues * 1000;
        AudioManager.Instance.PlaySFX(AudioManager.Instance.TimerTickAudio);
    }

    public override TimerInterval Clone()
    {  
        //Override to make a brand new object
        return new TimerIntervalRange(LowRangeValue, HighRangeValue, _LowRangeInclusive);
    }
}

